/* TestReHash.java
 *
 * Written by: Stuart Hansen
 * Spring 2004
 *
 * This program times how long it takes to rehash hashtables with a given 
 * amount of data stored in them.  It relies on Mike Clancy's
 * InstrumentedHashTable class which exposes (makes public) the rehash method.
 */

public class TestReHash
{

    public static void main (String [] args)
    {
        InstrumentedHashTable h;
        long t0, t1;
        for (int i=0; i<25; i++) {
            // Crank up the load factor so rehashing doesn't occur autmatically
            h = new InstrumentedHashTable(1000000, 30.0f);

            // Add some data to the hashtable
            for (int j=0; j<i*100000; j++) 
		h.put(new Integer(j), new Integer(i));

            // Time the rehashing
            System.gc();
            t0 = System.currentTimeMillis();
            h.rehash();           
            t1 = System.currentTimeMillis();
            System.out.println((i*100000) + " " + (t1-t0));
	}
    }
} 
