// InstrumentedHashTable.java
// Written by: Michael Clancy
// Date: ??
//
// Modified by: Stuart Hansen
// Date: January 31, 2004
//
// This class extends Java's Hashtable class allowing us to
// examine properties of the Hashtable.

import java.util.*;
import java.io.*;

public class InstrumentedHashTable extends Hashtable {

    // The constructors record the initialcapacity and loadFactor
    // for each Hashtable we create.
    public InstrumentedHashTable (int initialCapacity, float loadFactor ) {
	super (initialCapacity, loadFactor);
	myTableSize = initialCapacity;
        myLoadFactor = loadFactor;
    }

    public InstrumentedHashTable (int initialCapacity) {
	super (initialCapacity);
	myTableSize = initialCapacity;
        myLoadFactor = 0.75f;
    }

    public InstrumentedHashTable ()
    {
        super ();
        myTableSize = 11;
        myLoadFactor = 0.75f;
    }

    
    public void rehash ( ) {
        //System.out.println ("Rehashing: OldSize=" + myTableSize + " NewSize=" + (2*myTableSize+1));
	super.rehash ( );
	myTableSize = 2*myTableSize+1;
    }

    void produceStatistics (PrintStream counts) {
	int [ ] table = new int [myTableSize];
	Enumeration enum = keys ( );
	while (enum.hasMoreElements ( )) {
	    Object obj = enum.nextElement ( );
	    int hash = obj.hashCode ( );
	    int index = (hash & 0x07FFFFFFF) % table.length;
	    table[index]++;
	}
	int maxChainLength = table[0];
	int minChainLength = table[0];
	int elementCount = 0;
	int totalComparisons = 0;
	double avg;
	for (int k=0; k<table.length; k++) {
	    int chainLength = table[k];
	    maxChainLength = (chainLength > maxChainLength)? 
		chainLength: maxChainLength;
	    minChainLength = (chainLength < minChainLength)? 
		chainLength: minChainLength;
	    elementCount += chainLength;
	    // 1 + 2 + 3 + ... + chainLength = chainLength(chainLength+1)/2
	    totalComparisons += (chainLength*(chainLength+1))/2;
	}
	avg = ((float) totalComparisons)/elementCount;
	double avgChainLength = ((double) elementCount)/table.length;

	double sqSum = 0;
	for (int k=0; k<table.length; k++) {
	    sqSum += (table[k]-avgChainLength)*(table[k]-avgChainLength);
	}

	System.out.println ("Number of different elements in the table = " 
	    + elementCount);
	System.out.println ("Table size = " + table.length);
	System.out.println ("Maximum chain length = " + maxChainLength);
	System.out.println ("Minimum chain length = " + minChainLength);
	System.out.println ("Optimal chain length = "
	    + (elementCount + table.length - 1)/table.length);
	System.out.println ("Average # compares  = " + avg);
	System.out.println ("Standard deviation  = "
	    + Math.sqrt (sqSum/table.length));
	
	for (int k=0; k<myTableSize; k++) {
	    counts.println ("" + k + " " + table[k]);
	}
	counts.close ( );
    }

    private int myTableSize;
    private float myLoadFactor;
}
