import java.util.*;

/**
 * This class implements a O(n^2) merge sort.
 * The problem is declaring a large temp array in merge.
 * To correct the problem, either:
 *   a. make the temp array smaller
 *   b. declare temp in mergeSort and pass it as a parameter
 * 
 * @author Stuart Hansen 
 * @version May 3, 2004
 */
public class FinalCode
{
   // the public interface to the merge methods
   public static void mergeSort (int [] array)
   {
       mergeSort (array, 0, array.length-1);
   }
   
   // a private auxilliary method that uses extra parameters to try
   // to gain efficiency.
   private static void mergeSort (int [] array, int start, int end)
   {
       int mid = (end + start)/2;
       if (mid - start > 0) 
          mergeSort(array, start, mid);
       if (end - mid > 1) 
          mergeSort (array, mid+1, end);
       merge (array, start, mid, end);
   }

   // the merge method merges the lists into a temp array and then
   // copies that array back into array
   private static void merge (int [] array, int start1, int mid, int end)
   {
       int i1 = start1;
       int i2 = mid+1;
       int [] temp = new int [array.length];
       int i3 = 0;
       
       // while both sublists still have elements in them
       while (i1 <= mid && i2 <= end)
           if (array[i1] < array[i2])
               temp[i3++] = array[i1++];
           else
               temp[i3++] = array[i2++];

       // Copy the tail of the remaining list
       while (i1 <= mid)
          temp[i3++] = array[i1++];
          
       while (i2 <= end)
          temp[i3++] = array[i2++];

       // Copy temp back into the array.          
       int j=0;
       for (int i=start1; i<=end; i++)
          array[i] = temp[j++];
   }
   
   // the main method instantiates an array and starts
   // the whole thing running.
   public static void main (String [] args)
   {
       Random r = new Random();
       //MemUsed m = new MemUsed();
       for (int size=5000; size<=200000; size+=5000) {

          int [] array = new int [size];
          for (int i=0; i< size; i++)
             array[i] = i;
        
          for (int i=0; i< size; i++)
          {
              int j = r.nextInt(size-1);
              int temp = array[i];
              array[i] = array[j];
              array[j] = temp;
          }
       
          System.gc();
          long start = System.currentTimeMillis();
          mergeSort(array);
          long end = System.currentTimeMillis();

	  System.out.println(size + " " + (end-start)/1000.0);
          //m.reportMem();
	  //System.out.println();
       }
   }
}
