package empirical;
/*
 * Statistics.java
 *
 * Created on March 9, 2002, 3:17 PM
 
   Collect data and report simple statistics on the data
 *
 * @author  Stuart Hansen
 */

import java.util.*;
import java.lang.*;

public class Statistics {

    private Vector data;      // the data under consideration
    
    /** Creates new Statistics */
    public Statistics() {
        data = new Vector();
    }

    /** Adds an element to the collection of data */
    public void addElement (Number d) {
        data.add(d);
    }
    
    /** Returns the number of elements added to the data */
    public int size() {
        return data.size();
    }
    
    /** Returns the average of the data */
    public double getAverage() {
        double sum = 0.0;
        for (int i=0; i<data.size(); i++)
            sum += ((Number)data.get(i)).doubleValue();
        if (data.size() != 0)
            return sum/data.size();
        else {
            System.err.println("Cannot take the average of zero numbers");
            return 0.0;
        }
    }
    
    /** Returns the sample standard deviation of the data */
    public double getStandDev() {
        double sum = 0.0;
        double avg = getAverage();
        for (int i=0; i<data.size(); i++) {
            double d = ((Number)data.get(i)).doubleValue();
            sum += (d-avg)*(d-avg);
        }
        if (data.size() > 1)
            return Math.sqrt(sum/(data.size()-1));
        else {
            System.err.println("Cannot take the sample standard deviation of fewer than 2 numbers");
            return 0.0;
        }        
    }
    
    /** Returns the maximum value in the data */
    public double getMax() {
        double max = Double.NEGATIVE_INFINITY;
        for (int i=0; i<data.size(); i++) {
            double d = ((Number)data.get(i)).doubleValue();            
            if (d>max) max = d;
        }
        return max;
    }        
    
    /** Returns the minimum value in the data */
    public double getMin() {
        double min = Double.POSITIVE_INFINITY;
        for (int i=0; i<data.size(); i++) {
            double d = ((Number)data.get(i)).doubleValue();            
            if (d<min) min = d;
        }
        return min;
    }    
}
