package empirical;
/*
 * Memory.java
 *
 * Created on March 7, 2002, 1:16 PM
 *
 * Provides some basic functionality for students to explore the memory
 * used by the stack and heap.
 *
 * @author  Stuart Hansen 
 */

import java.lang.*;

public class Memory {
    
    /** Returns the number of frames in the current thread's stack.
     *  This uses a deprecated API.
     */
    public static int getStackFrameCount() {
       return Thread.currentThread().countStackFrames();
    }
            
    /** Returns the number of bytes used by the current program. 
     *   No garbage collection is done. */
    public static long getUsedMemory() {
        return getUsedMemory(false);
    }
    
    /** Returns the number of bytes used by the current program. 
     *  gc tells whether to do garbage collection before measuring used memory */
    public static long getUsedMemory(boolean gc) {
        Runtime rt = Runtime.getRuntime();
        if (gc) System.gc();
        return rt.totalMemory() - rt.freeMemory();
    }

}
