package empirical;
/*
 * IntegerIndexedFactory.java
 *
 * Created on March 9, 2002, 1:12 PM

   Contains a factory that produces Indexed collections of Integers and a comparator
   to use when sorting them.
   It is built to  work with Budd's CS2 text.
    
 * @author  Stuart Hansen 
 */

//import java.util.*;
import jds.collection.*;
import jds.util.*;
import jds.*;

public class IntegerIndexedFactory {

    private Vector data;
    java.util.Random rand = new java.util.Random();

    /** Creates a new IntegerIndexedFactory */
    public IntegerIndexedFactory() {
        this(100);
    }

    /** Creates a new IntegerIndexedFactory that returns vectors of size nsize*/
    public IntegerIndexedFactory(int nsize) {
        data = new Vector();
        for (int i=0; i<nsize; i++) 
            data.addLast(new Integer(i));
    }
    
    /** Creates a new IntegerIndexedFactory that returns vectors that are permutations of
        array
     */
    public IntegerIndexedFactory(Vector v) {
        data = new Vector ();
        for (int i=0; i<v.size(); i++) {
            try {
                data.addLast((Integer) v.elementAt(i));
            }
            catch (ClassCastException e) {
                System.err.println(v.elementAt(i) + " is not an integer, ignoring");
            }
        }        
    }
    
    /** Generates and returns a random permutation of the original vectors */
    public Indexed randomPermutation () {
        int array [] = new int [data.size()];
        for (int i=0; i<data.size(); i++) array[i] = ((Integer)data.elementAt(i)).intValue();
        for (int i=0; i<array.length; i++) {
            int j = Math.abs(rand.nextInt())%array.length;
            int temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
        Vector v = new Vector();
        for (int i=0; i<array.length; i++)
            v.addLast(new Integer(array[i]));
        return (Indexed) v; 
    }
    
    /** Generates and returns an almost sorted permutation of the original array.
        mix controls how mixed up the array is.  Swaps are performed until the
        percentage of out of place elements exceeds mix.  If mix = 0, the array
        is sorted.  If mix = 1.0, no element is in place. 
    */
    public Indexed almostSortedPermutation(double mix) {
        int array [] = new int[data.size()];
        for (int i=0; i<data.size(); i++) array[i] = ((Integer)data.elementAt(i)).intValue();
        sort(array);
        
        int array2 [] = new int [array.length];
        System.arraycopy(array, 0, array2, 0, array.length);
        
        int outOfPlace = (int) (array.length*mix);
        int i=0;
        while(i < outOfPlace) {
            int j = Math.abs(rand.nextInt())%array.length;
            int k = Math.abs(rand.nextInt())%array.length;
            
            if (array[j] != array[k]) {
                if (array[j] == array2[j]) i++;
                if (array[k] == array2[k]) i++;
                if (array[k] == array2[j]) i--;
                if (array[j] == array2[k]) i--;
                int temp = array[k];
                array[k] = array[j];
                array[j] = temp;
            }
        }
        Vector v = new Vector();
        for (i=0; i<array.length; i++) 
            v.addLast(new Integer(array[i]));
        return (jds.Indexed) v;
    }
    
    /** A method to set the random number seed, allowing users to recreate the
        exact data used on a previous run 
     */
    public void setSeed (long seed) {
        rand.setSeed(seed);
    }
    
    /** A quick and dirty merge sort for use by almostSortedPermutation*/
    private void sort (int [] array) {
        if (array.length < 2) 
            return;
        
        int a1[] = new int [(array.length+1)/2];
        System.arraycopy(array, 0, a1, 0, (array.length+1)/2);
        sort (a1);
        
        int a2[] = new int [(array.length)/2];
        System.arraycopy(array, (array.length+1)/2, a2, 0, array.length/2);
        sort(a2);
        
        int a1count = 0;
        int a2count = 0;
        int arraycount = 0;
        
        while (a1count < a1.length && a2count < a2.length) {
            if (a1[a1count] < a2[a2count]) {
                array[arraycount] = a1[a1count];
                arraycount++;
                a1count++;
            }
            else {
                array[arraycount] = a2[a2count];
                arraycount++;
                a2count++;
            }
        }
        while (a1count < a1.length) {
            array[arraycount] = a1[a1count];
            arraycount++;
            a1count++;
        }
        while (a2count < a2.length) {
            array[arraycount] = a2[a2count];
            arraycount++;
            a2count++;
        }     
    }
    
    /* returns a comparator for Integers */
    public java.util.Comparator getComparator() {
        return IntegerComparator.getInstance();
    }        
}

/** IntegerComparator compares Integers */
class IntegerComparator implements java.util.Comparator {
    private static IntegerComparator instance = new IntegerComparator();
    
    /** Our private constructor enforces the singleton design pattern */
    private IntegerComparator() {}
    
    /** compare relies on Integer's compareTo method to do the work */
    public int compare (Object o1, Object o2) {
        Integer i1 = (Integer) o1;
        Integer i2 = (Integer) o2;
        return i1.compareTo(i2);
    }
    
    /** returns the comparator */
    public static java.util.Comparator getInstance() {
        return instance;
    }
    
}
    