package empirical;
/*
 * IntegerArrayFactory.java
 *
 * Created on May 3, 2002

   Contains a factory that produces arrays of ints in various orders.
   It is built to  work with Wu's CS1 text UW-Parkside's CS1 Lab 12.
    
 * @author  Stuart Hansen 
 */

public class IntArrayFactory {

    private int[] data;
    java.util.Random rand = new java.util.Random();

    /** Creates a new IntegerIndexedFactory */
    public IntArrayFactory() {
        this(100);
    }

    /** Creates a new IntArrayFactory that returns arrays of size nsize*/
    public IntArrayFactory(int nsize) {
        data = new int[nsize];
        for (int i=0; i<nsize; i++) { 
            data[i] = i;
        }
    }
    
    /** Creates a new IntArrayFactory that returns arrays that are permutations of
        the array parameter
     */
    public IntArrayFactory(int arr[]) {
        data = new int[arr.length];
        for (int i=0; i<arr.length; i++) {
            data[i] = arr[i];
        }        
    }
    
    /** Generates and returns a random permutation of the array */
    public int[] randomPermutation () {
        int array [] = new int [data.length];
        for (int i=0; i<data.size(); i++) 
            array[i] = data[i];
        for (int i=0; i<array.length; i++) {
            int j = Math.abs(rand.nextInt())%array.length;
            int temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
        for (int i=0; i<data.size(); i++) 
            data[i] = array[i];

        return array; 
    }

    /** Returns the same array that was returned from the previous call to 
        randomPermutation, samePermutation or sortedPermutation.
        Returns the array from the constructor if no previous call has been made */
    public int[] samePermutation () {
        int array [] = new int [data.length];
        for (int i=0; i<data.size(); i++) 
            array[i] = data[i];
        return array; 
    }
    
    /** Returns an array that is sorted in ascending order */
    public int[] sortedPermutation () {
        int array [] = new int [data.length];
        sort(data);
        for (int i=0; i<data.size(); i++) 
            array[i] = data[i];
        return array; 
    }

    
    /** A method to set the random number seed, allowing users to recreate the
        exact data used on a previous run 
     */
    public void setSeed (long seed) {
        rand.setSeed(seed);
    }
    
    /** A quick and dirty merge sort */
    private void sort (int [] array) {
        if (array.length < 2) 
            return;
        
        int a1[] = new int [(array.length+1)/2];
        System.arraycopy(array, 0, a1, 0, (array.length+1)/2);
        sort (a1);
        
        int a2[] = new int [(array.length)/2];
        System.arraycopy(array, (array.length+1)/2, a2, 0, array.length/2);
        sort(a2);
        
        int a1count = 0;
        int a2count = 0;
        int arraycount = 0;
        
        while (a1count < a1.length && a2count < a2.length) {
            if (a1[a1count] < a2[a2count]) {
                array[arraycount] = a1[a1count];
                arraycount++;
                a1count++;
            }
            else {
                array[arraycount] = a2[a2count];
                arraycount++;
                a2count++;
            }
        }
        while (a1count < a1.length) {
            array[arraycount] = a1[a1count];
            arraycount++;
            a1count++;
        }
        while (a2count < a2.length) {
            array[arraycount] = a2[a2count];
            arraycount++;
            a2count++;
        }     
    }     
}
