package empirical;
/*
 * IntegerArrayFactory.java
 *
 * Created on May 3, 2002

   Contains a factory that produces arrays of ints in various orders.
   It is built to  work with Wu's CS1 text UW-Parkside's CS1 Lab 12.
    
 * @author  Stuart Hansen 
 */

public class IntArrayFactory {

    private int[] data;
    java.util.Random rand = new java.util.Random();

    /** Creates a new IntegerIndexedFactory */
    public IntArrayFactory() {
        this(100);
    }

    /** Creates a new IntArrayFactory that returns arrays of size nsize*/
    public IntArrayFactory(int nsize) {
        data = new int[nsize];
        for (int i=0; i<nsize; i++) { 
            data[i] = i;
        }
    }
    
    /** Creates a new IntArrayFactory that returns arrays that are permutations of
        the array parameter
     */
    public IntArrayFactory(int arr[]) {
        data = new int[arr.length];
        System.arraycopy(data, 0, arr, 0, data.length);      
    }
    
    /** Generates and returns a random permutation of the array */
    public int[] randomPermutation () {
        int array [] = new int [data.length];
        for (int i=0; i<data.length; i++) {
            int j = Math.abs(rand.nextInt())%data.length;
            int temp = data[i];
            data[i] = data[j];
            data[j] = temp;
        }
        System.arraycopy(data, 0, array, 0, data.length);
        return array; 
    }

    /** Returns the same array that was returned from the previous call to 
        randomPermutation, samePermutation or sortedPermutation.
        Returns the array from the constructor if no previous call has been made */
    public int[] samePermutation () {
        int array [] = new int [data.length];
        System.arraycopy(data, 0, array, 0, data.length);
        return array; 
    }
    
    /** Returns an array that is sorted in ascending order */
    public int[] sortedPermutation () {
        int array [] = new int [data.length];
        sort(data);
        System.arraycopy(data, 0, array, 0, data.length);
        return array; 
    }

    /** returns an almost sorted array with approximately mix percent
        of the elements out of place */
    public int [] almostSortedPermutation(double mix) {
        int array [] = new int [data.length];
        System.arraycopy(data, 0, array, 0, data.length);

        sort(array);
        
        int array2 [] = new int [array.length];
        System.arraycopy(array, 0, array2, 0, array.length);
        
        int outOfPlace = (int) (array.length*mix);
        int i=0;
        while(i < outOfPlace) {
            int j = Math.abs(rand.nextInt())%array.length;
            int k = Math.abs(rand.nextInt())%array.length;
            
            if (array[j] != array[k]) {
                if (array[j] == array2[j]) i++;
                if (array[k] == array2[k]) i++;
                if (array[k] == array2[j]) i--;
                if (array[j] == array2[k]) i--;
                int temp = array[k];
                array[k] = array[j];
                array[j] = temp;
            }
        }

        System.arraycopy(array, 0, data, 0, array.length);
        return array;
    }

    /** A method to set the random number seed, allowing users to recreate the
        exact data used on a previous run 
     */
    public void setSeed (long seed) {
        rand.setSeed(seed);
    }
    
    /** A quick and dirty merge sort */
    private void sort (int [] array) {
        if (array.length < 2) 
            return;
        
        int a1[] = new int [(array.length+1)/2];
        System.arraycopy(array, 0, a1, 0, (array.length+1)/2);
        sort (a1);
        
        int a2[] = new int [(array.length)/2];
        System.arraycopy(array, (array.length+1)/2, a2, 0, array.length/2);
        sort(a2);
        
        int a1count = 0;
        int a2count = 0;
        int arraycount = 0;
        
        while (a1count < a1.length && a2count < a2.length) {
            if (a1[a1count] < a2[a2count]) {
                array[arraycount] = a1[a1count];
                arraycount++;
                a1count++;
            }
            else {
                array[arraycount] = a2[a2count];
                arraycount++;
                a2count++;
            }
        }
        while (a1count < a1.length) {
            array[arraycount] = a1[a1count];
            arraycount++;
            a1count++;
        }
        while (a2count < a2.length) {
            array[arraycount] = a2[a2count];
            arraycount++;
            a2count++;
        }     
    }     
}
