package empirical;
/*
 * AlgTimer.java
 *
 * Created on March 7, 2002, 12:11 PM
 *
 * An AlgTimer is a class to facilitate the timing of algorithms.
 * It relies on System.currentTimeMillis() and is only as accurate
 * as that method.
 *
 *
 * @author  Stuart Hansen
 */
public class AlgTimer {

    private long startTime;   // the milliseconds when the timer started
    private long endTime;     // the milliseconds when the timer stopped
    private boolean running;  // a flag that says the timer is running
    
    /** Creates new AlgTimer */
    public AlgTimer() {
        startTime = 0;
        endTime = 0;
        running = false;
    }

    /** Starts the timer running.  Note that the timer is not cumulative.
     *  That is, each time the timer is started, it resets to 0
     */
    public void start() {
        running = true;
        endTime = 0;
        startTime = System.currentTimeMillis();
    }
    
    /** Stops the timer.  A timer must be stopped before getTimeInMillis will work.
     */
    public void stop () {
        endTime = System.currentTimeMillis();
        running = false;
    }
    
    /** returns the number of milliseconds the timer has been running
     */
    public long getMillis () {
        if (running) 
            throw new AlgTimerRunningException();
        else
            return endTime - startTime;
    }
}
